-- new script file

function OnAfterSceneLoaded(self) 
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
        
    if not self.loaded then
      self.attackLTactive = false
      self.attackLimit = 420 / Citadels.GetPlayer(0):GetDifficultyCoef()
      self.attackTimer = self.attackLimit
    end
    
    self.attackLT:LinkToTarget("attLT")
  end
  
  if self.attackLTactive then
    self.td = Timer:GetTimeDiff()
    self.attackTimer = self.attackTimer - self.td
    
    if self.attackTimer <= 0 then
      self.attackLimit = self.attackLimit * 0.95
      self.attackTimer = self.attackLimit
      self.attackLT:TriggerAllTargets()
    end  
  end
end

function OnTrigger(self, source, target)
  Debug:Log("Activated: " .. target)
  if target == "activateAttackLt" then
    self.attackLTactive = true
  elseif target == "stopAttackLt" then
    self.attackLTactive = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.attackLTactive = ar:Read()
    self.attackLimit = ar:Read()
    self.attackTimer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attackLTactive)
    ar:Write(self.attackLimit)
    ar:Write(self.attackTimer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("activateAttackLt")
  self:AddTriggerTarget("stopAttackLt")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("attackLT")
end

